/* - MCErrorListener -
 * Display the data from a sensor update event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.event.SensorUpdateListener;
import com.phidgets.event.SensorUpdateEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MCSensorUpdateListener implements SensorUpdateListener {

    private JComboBox motorCmb;
    private JTextField sensorArray[];

    public MCSensorUpdateListener(JTextField sensorArray[], JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.sensorArray = sensorArray;
    }

    public void sensorUpdated(SensorUpdateEvent sensorUpdateEvent) {
        sensorArray[sensorUpdateEvent.getIndex()].setText(Integer.toString(sensorUpdateEvent.getValue()));
    }
}
